Attribute VB_Name = "ShrinkWrapper"
' This is a part of the source code for Pro/DESKTOP.
' Copyright (C) 2002 Parametric Technology Corporation.
' All rights reserved.

'This macro creates the Use Component feature for all the components of
'active design. If the design contains any subassemblies, then it modifies the
'subassemblies by opening them in separate documents and shrinkwrapping
'them as well.

Dim app As ProDESKTOP

Sub Main() 'initialize
    Set app = CreateObject("ProDESKTOP.Application")
    app.SetVisible True
     
    Dim doc As GraphicDocument
    Set doc = app.GetActiveDoc
    
    If Not (TypeOf doc Is PartDocument) Then
        MsgBox "Active document is not a design. Please activate a design and try again.", vbInformation
        Exit Sub
    End If
    
    Dim des As aDesign
    Set des = doc.GetDesign
    
    If des.GetComponents.GetCount > 0 Then
       ShrinkWrapper des
       app.ActivateDoc doc
    Else
       MsgBox "Active design is not an assembly.", vbInformation
    End If
    
 End Sub

Private Sub ShrinkWrapper(design As aDesign) 'Use Component

    Dim doc As PartDocument
    If design.IsA("DesignInstance") Then
        Set doc = app.OpenPart(design.GetOriginal.GetFile.GetName)
    Else
        Set doc = app.GetActiveDoc
    End If
        
    Dim compSet As ObjectSet
    Set compSet = doc.GetDesign.GetComponents
    
    Dim it As Iterator
    Set it = app.GetClass("It").CreateAObjectIt(compSet)
     
    it.start
    While it.IsActive
        If it.Current.GetComponents.GetCount > 0 Then
        ShrinkWrapper it.Current
        End If
    it.Next
    Wend
    
    CreateUseComponents doc
End Sub

Private Sub CreateUseComponents(doc As PartDocument)
  
  Dim compSet As ObjectSet
  Set compSet = doc.GetDesign.GetComponents
    
  Dim it As Iterator
  Set it = app.GetClass("It").CreateAObjectIt(compSet)
    
  Dim ToolCls As ToolClass
  Dim tool As aTool
  Set ToolCls = app.GetClass("Tool")
    
  it.start
  While it.IsActive
        Set tool = ToolCls.CreateTool(doc.GetDesign, it.Current, 1)
        it.Current.SetHidden 1
        tool.SetName it.Current.GetName
     it.Next
  Wend
  
  doc.UpdateDesign2 Nothing
End Sub
